package com.getmati.mati_sdk.server.api

import com.getmati.mati_sdk.models.clean.verification.VerificationType
import com.getmati.mati_sdk.models.api.response.ApiResponse
import com.getmati.mati_sdk.managers.request_manager.postCatching
import io.ktor.client.*
import io.ktor.client.request.*
import io.ktor.http.*

internal class ConnectionApi(private val client: HttpClient) {

    suspend fun connect(verificationId: String): ApiResponse<Unit> {
        val inputId = VerificationType.CONNECTION_DATA.id
        return client.postCatching("verifications/${verificationId}/inputs/${inputId}") {
            contentType(ContentType.Application.Json)
        }
    }
}