package com.getmati.mati_sdk.server.api

import com.getmati.mati_sdk.models.clean.CustomDoc
import com.getmati.mati_sdk.models.clean.DocPage
import com.getmati.mati_sdk.models.api.request.MediaType
import com.getmati.mati_sdk.models.api.response.ApiResponse
import com.getmati.mati_sdk.managers.request_manager.submitFormCatching
import com.getmati.mati_sdk.ui.utils.Util
import io.ktor.client.*
import io.ktor.client.request.*
import io.ktor.client.request.forms.*
import io.ktor.http.*
import java.io.File

internal class CustomDocUploadApi(private val client: HttpClient) {

    suspend fun uploadCustomDoc(verificationId: String, filePath: String,
                                docPage: DocPage<CustomDoc>? = null): ApiResponse<Unit> {
        val mediaType = MediaType.CUSTOM_DOCUMENT
        return client.submitFormCatching(
            url = "file",
            formData = formData {
                append("verificationId", verificationId)
                append("inputId", mediaType.code)
                docPage?.run {
                    with(document) {
                        append("documentType", id)
                        country?.let { append("country", it.code) }
                        region?.let { append("region", it) }
                        append("pageId", if (singleFile) "multi" else if (isFrontSide) "front" else "back")
                    }
                }
                val file = File(filePath)
                append(mediaType.multiPartKey, file.readBytes(), Headers.build {
                    val type = Util.getMimeTime(filePath)
                    type?.let { append(HttpHeaders.ContentType, type) }
                    append(HttpHeaders.ContentDisposition, "filename=${file.name}")
                })
            }
        )
    }
}

