package com.getmati.mati_sdk.server.api

import com.getmati.mati_sdk.models.api.request.ESignData
import com.getmati.mati_sdk.models.api.request.ESignReadDetails
import com.getmati.mati_sdk.models.api.request.ESignUploadData
import com.getmati.mati_sdk.models.api.request.ESignUploadRequestBody
import com.getmati.mati_sdk.models.clean.verification.VerificationType
import com.getmati.mati_sdk.models.api.response.ApiResponse
import com.getmati.mati_sdk.managers.request_manager.postCatching
import io.ktor.client.*
import io.ktor.client.request.*
import io.ktor.http.*

internal class ESignApi(private val client: HttpClient) {

    suspend fun accept(verificationId: String, name: String,
                       documentIdToReadTime: Map<String, String>): ApiResponse<Unit> {
        val inputId = VerificationType.E_SIGN.id
        return client.postCatching("verifications/${verificationId}/inputs/${inputId}") {
            contentType(ContentType.Application.Json)

            val readDetails = mutableListOf<ESignReadDetails>()
            documentIdToReadTime.forEach {
                readDetails += ESignReadDetails(it.key, it.value)
            }
            val eSignData = ESignData(name, readDetails)
            body = ESignUploadRequestBody(ESignUploadData(data = eSignData), inputType = inputId)
        }
    }
}