package com.getmati.mati_sdk.server.api

import com.getmati.mati_sdk.models.api.request.EmailUploadData
import com.getmati.mati_sdk.models.api.request.EmailUploadRequestBody
import com.getmati.mati_sdk.models.clean.verification.VerificationType
import com.getmati.mati_sdk.models.api.response.ApiResponse
import com.getmati.mati_sdk.managers.request_manager.postCatching
import com.getmati.mati_sdk.ui.utils.LocaleManager
import io.ktor.client.*
import io.ktor.http.*

internal class EmailProcessApi(private val client: HttpClient) {

    suspend fun submitEmail(verificationId: String, emailAddress: String): ApiResponse<Unit> {
        val inputId = VerificationType.EMAIL_VERIFICATION.id
        return client.postCatching("verifications/${verificationId}/inputs/${inputId}") {
            contentType(ContentType.Application.Json)
            val emailUploadData = EmailUploadData(
                emailAddress = emailAddress, locale = LocaleManager.getLanguage().iso
            )
            val requestBody = EmailUploadRequestBody(uploadData = emailUploadData, inputType = inputId)
            body = requestBody
        }
    }

    suspend fun verifyEmail(verificationId: String, emailAddress: String, code: String): ApiResponse<Unit> {
        val inputId = VerificationType.EMAIL_VERIFICATION.id
        return client.postCatching("verifications/${verificationId}/inputs/${inputId}") {
            contentType(ContentType.Application.Json)
            val emailUploadData = EmailUploadData(
                emailAddress = emailAddress,
                locale = LocaleManager.getLanguage().iso,
                confirmationCode = code
            )
            val requestBody = EmailUploadRequestBody(uploadData = emailUploadData, inputType = inputId)
            body = requestBody
        }
    }
}