package com.getmati.mati_sdk.server.api

import android.util.Base64
import com.getmati.mati_sdk.Metadata
import com.getmati.mati_sdk.models.api.request.CreateVerificationRequestBody
import com.getmati.mati_sdk.models.api.response.ApiResponse
import com.getmati.mati_sdk.models.api.response.CreateVerificationResponse
import com.getmati.mati_sdk.models.api.response.NewAuthorizationTokenResponse
import com.getmati.mati_sdk.managers.request_manager.postCatching
import io.ktor.client.*
import io.ktor.client.request.*
import io.ktor.client.request.forms.*
import io.ktor.http.*
import kotlinx.serialization.json.Json
import kotlin.text.toByteArray

internal class InitializationApi(private val client: HttpClient, private val jsonBuilder: Json) {

    suspend fun createAuthToken(clientId: String, flowId: String?): ApiResponse<NewAuthorizationTokenResponse> {
        return client.postCatching("oauth/token") {
            val base64 = Base64.encodeToString(
                String.format("%s:", clientId).toByteArray(), Base64.NO_WRAP
            )
            header("Authorization", "Basic $base64") // TODO Optimize

            val formParameters = Parameters.build {
                append("grant_type", "application_key")
                append("application_key", clientId)
                append("scope", "openid verification_flow")
                flowId?.let { append("flow_id", it) }
            }
            body = FormDataContent(formParameters)
        }
    }

    suspend fun createVerification(accessToken: String, flowId: String?,
                                   identityId: String?, metadata: Metadata?): ApiResponse<CreateVerificationResponse> {
        return client.postCatching("verifications") {
            header("Authorization", "Basic $accessToken")
            contentType(ContentType.Application.Json)
            val metadataJson = metadata?.dataJson?.let {
                jsonBuilder.parseToJsonElement(it.toString())
            }
            val createVerificationRequestBody = CreateVerificationRequestBody(
                flowId = flowId,
                identityId = identityId,
                metadata = metadataJson
            )
            body = createVerificationRequestBody
        }
    }
}