package com.getmati.mati_sdk.server.api

import com.getmati.mati_sdk.models.api.response.ApiResponse
import com.getmati.mati_sdk.managers.request_manager.getCatching
import io.ktor.client.*
import io.ktor.client.request.*
import io.ktor.http.*

internal class MediaDownloadApi(private val client: HttpClient) {

    suspend fun downloadMedia(location: String): ApiResponse<ByteArray> {
        return client.getCatching("file/?location=$location")
    }
}

