package com.getmati.mati_sdk.server.api

import com.getmati.mati_sdk.models.clean.DocPage
import com.getmati.mati_sdk.models.api.request.MediaType
import com.getmati.mati_sdk.models.api.response.ApiResponse
import com.getmati.mati_sdk.managers.request_manager.submitFormCatching
import com.getmati.mati_sdk.ui.utils.Util
import io.ktor.client.*
import io.ktor.client.request.*
import io.ktor.client.request.forms.*
import io.ktor.http.*
import java.io.File

internal open class MediaUploadApi(private val client: HttpClient) {

    open suspend fun uploadMedia(verificationId: String, mediaType: MediaType,
                                 filePath: String, docPage: DocPage<*>? = null): ApiResponse<Unit> {
        return client.submitFormCatching(
            url = "file",
            formData = formData {
                append("verificationId", verificationId)
                append("inputId", mediaType.code)
                docPage?.run {
                    with(document) {
                        append("documentType", id)
                        country?.let { append("country", it.code) }
                        region?.let { append("region", it) }
                        exportMetaData()?.let{ append("overriddenFields", it)}
                    }
                    append("pageId", if (isFrontSide) "front" else "back")
                }
                val file = File(filePath)
                append(mediaType.multiPartKey, file.readBytes(), Headers.build {
                    val type = Util.getMimeTime(filePath)
                    type?.let { append(HttpHeaders.ContentType, type) }
                    append(HttpHeaders.ContentDisposition, "filename=${file.name}")
                })
            }
        )
    }
}

