package com.getmati.mati_sdk.server.api

import com.getmati.mati_sdk.models.api.request.PhoneUploadData
import com.getmati.mati_sdk.models.api.request.PhoneUploadRequestBody
import com.getmati.mati_sdk.models.clean.Country
import com.getmati.mati_sdk.models.clean.verification.VerificationType
import com.getmati.mati_sdk.models.api.response.ApiResponse
import com.getmati.mati_sdk.managers.request_manager.postCatching
import com.getmati.mati_sdk.ui.utils.LocaleManager
import io.ktor.client.*
import io.ktor.http.*

internal class PhoneInputApi(private val client: HttpClient) {

    suspend fun sendSms(verificationId: String, phoneNumber: String, selectedCountry: Country): ApiResponse<Unit> {
        val inputId = VerificationType.PHONE_VERIFICATION.id
        return client.postCatching("verifications/${verificationId}/inputs/${inputId}") {
            contentType(ContentType.Application.Json)
            val phoneUploadData = PhoneUploadData(
                phoneNumber = phoneNumber,
                countryCode = selectedCountry.code,
                dialingCode = selectedCountry.dialingCode,
                locale = LocaleManager.getLanguage().iso
            )
            val requestBody = PhoneUploadRequestBody(uploadData = phoneUploadData, inputType = inputId)
            body = requestBody
        }
    }

    suspend fun processVerification(verificationId: String, phoneNumber: String, selectedCountry: Country,
                                    code: String): ApiResponse<Unit> {
        val inputId = VerificationType.PHONE_VERIFICATION.id
        return client.postCatching("verifications/${verificationId}/inputs/${inputId}") {
            contentType(ContentType.Application.Json)
            val phoneUploadData = PhoneUploadData(
                phoneNumber = phoneNumber,
                countryCode = selectedCountry.code,
                dialingCode = selectedCountry.dialingCode,
                locale = LocaleManager.getLanguage().iso,
                confirmationCode = code
            )
            val requestBody = PhoneUploadRequestBody(uploadData = phoneUploadData, inputType = inputId)
            body = requestBody
        }
    }
}