package com.getmati.mati_sdk.server.api

import com.getmati.mati_sdk.models.api.request.SkipDocRequestBody
import com.getmati.mati_sdk.models.api.response.ApiResponse
import com.getmati.mati_sdk.managers.request_manager.putCatching
import io.ktor.client.*
import io.ktor.client.request.*
import io.ktor.http.*

internal class SkipApi(private val client: HttpClient) {

    suspend fun skip(verificationId: String, inputId: String): ApiResponse<Unit> {
        return skipInternal(verificationId, inputId)
    }

    suspend fun skipDoc(verificationId: String, inputId: String,
                        documentType: String, group: Int): ApiResponse<Unit> {
        return skipInternal(verificationId, inputId) {
            body = SkipDocRequestBody(documentType = documentType, group = group)
        }
    }

    private suspend fun skipInternal(verificationId: String, inputId: String,
                                     requestBuilder: HttpRequestBuilder.() -> Unit = {}): ApiResponse<Unit> {
        return client.putCatching("verifications/${verificationId}/inputs/${inputId}/skip") {
            contentType(ContentType.Application.Json)
            requestBuilder()
        }
    }
}