package com.getmati.mati_sdk.server.verification

import com.getmati.mati_sdk.models.clean.MediaVerificationError

internal data class StepVerificationResult<T>(
    val data: T? = null,
    val error: VerificationError?
)

internal data class VerificationError(
    val type: MediaVerificationError,
    val details: ErrorDetails? = null
)

internal sealed class ErrorDetails {
    data class VoiceLivenessErrorDetails(val text: String? = null) : ErrorDetails()
    data class RestrictionErrorDetails(val optional: Boolean = false, val triesCount: Int = 0) : ErrorDetails()
}
