package com.getmati.mati_sdk.ui

import android.os.Parcelable
import com.getmati.mati_sdk.models.clean.Document
import com.getmati.mati_sdk.ui.esign.model.DocToSign
import kotlinx.parcelize.Parcelize
import org.json.JSONArray
import org.json.JSONObject

internal abstract class VerificationStep {
    abstract fun putToJson(target: JSONObject)
}

@Parcelize
internal data class DocumentVerificationStep(val acceptableDocuments: List<Document>, val group: Int) : VerificationStep(), Parcelable {
    override fun putToJson(target: JSONObject) {
        target.put("verificationStep", JSONObject().apply {
            put("name", "documentUpload")
            put("acceptedDocumentTypes", JSONArray(acceptableDocuments.map { it.id }))
            put("group", group)
        })
    }
}

@Parcelize
internal data class BiometryUpload(val biometryType: BiometryType) : VerificationStep(), Parcelable {
    override fun putToJson(target: JSONObject) {
        target.put("verificationStep", JSONObject().apply {
            put("name", "biometryUpload")
            put("biometryType", biometryType.id)
        })
    }
}

@Parcelize
internal data class SmsUpload(val optional:Boolean, val smsInputCount: Int = 3, val timeoutMs: Int = 60_000) : VerificationStep(), Parcelable {
    override fun putToJson(target: JSONObject) {
        target.put("verificationStep", "phoneVerification")
    }
}

@Parcelize
internal class ESignVerificationStep(val docsToSign: List<DocToSign>) : VerificationStep(), Parcelable {
    override fun putToJson(target: JSONObject) {
        target.put("verificationStep", "electronicSignature")
    }
}

@Parcelize
internal data class EmailVerification(
        val optional: Boolean,
        val attemptLimit: Int,
        val coolDown: Int
) : VerificationStep(), Parcelable {
    override fun putToJson(target: JSONObject) {
        target.put("verificationStep", "emailVerification")
    }

    companion object {
        const val KEY_OPTIONAL = "optional"
    }
}

@Parcelize
internal data class WebVerificationStep(val type: String) : VerificationStep(), Parcelable {
    override fun putToJson(target: JSONObject) {
        target.put("verificationStep", JSONObject().apply {
            put("type", type)
        })
    }
}

internal enum class BiometryType(val id: String) {
    NONE("none"),
    SELFIE("selfie"),
    SELFIE_VIDEO("liveness"),
    VOICE_LIVENESS("voice+liveness");

    companion object {
        fun fromJson(id: String): BiometryType {
            return values().firstOrNull { it.id == id } ?: NONE
        }
    }
}
