package com.getmati.mati_sdk.ui.camera

import androidx.camera.core.CameraProvider
import androidx.camera.core.CameraSelector


internal const val MISSING_LENS_VALUE = -1
internal fun CameraProvider.defineLens(desiredLens: Int) = when (desiredLens) {
    CameraSelector.LENS_FACING_BACK -> when {
        hasCamera(CameraSelector.DEFAULT_BACK_CAMERA) -> CameraSelector.LENS_FACING_BACK
        hasCamera(CameraSelector.DEFAULT_FRONT_CAMERA) -> CameraSelector.LENS_FACING_FRONT
        else -> MISSING_LENS_VALUE
    }
    CameraSelector.LENS_FACING_FRONT -> when {
        hasCamera(CameraSelector.DEFAULT_FRONT_CAMERA) -> CameraSelector.LENS_FACING_FRONT
        hasCamera(CameraSelector.DEFAULT_BACK_CAMERA) -> CameraSelector.LENS_FACING_BACK
        else -> MISSING_LENS_VALUE
    }
    else -> throw IllegalStateException("Camera lens facing cannot have other value than 0 or 1")
}