package com.getmati.mati_sdk.ui.common

import android.os.Bundle
import android.view.View
import com.getmati.mati_sdk.R
import com.getmati.mati_sdk.analytics.events.Clicked
import com.getmati.mati_sdk.analytics.events.UserAction
import com.getmati.mati_sdk.analytics.track
import com.getmati.mati_sdk.databinding.FragmentExitBinding
import com.getmati.mati_sdk.mati_navigation.MatiDestination
import com.getmati.mati_sdk.ui.utils.view_binding.viewBinding
import com.getmati.mati_sdk.widgets.MatiToolbar

internal class ExitFragment : KYCBaseFragment(R.layout.fragment_exit) {

    override val screenName = "verificationExit"
    private val binding by viewBinding(FragmentExitBinding::bind)

    override fun configureToolbar(toolbar: MatiToolbar) {
        super.configureToolbar(toolbar)
        toolbar.setCloseImageVisibile(false)
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        binding.innerTitleTvExitFragment.text = requireContext().getString(R.string.label_want_to_leave_verification)
        binding.innerSubtitleTvExitFragment.text = requireContext().getString(R.string.label_you_will_lose_all_uploaded_information)
        binding.actionPrimary.text = requireContext().getString(R.string.label_exit)
        binding.labelContinueVerification.text = requireContext().getString(R.string.label_continue_verification)
        binding.actionPrimary.setOnClickListener {
            track(UserAction("primaryButton", Clicked(), screenName))
            navigation.cancelVerification()
        }
        binding.labelContinueVerification.setOnClickListener {
            track(UserAction("continueButton", Clicked(), screenName))
            navigation.back()
        }
    }

    companion object {
        fun destination(): MatiDestination {
            return MatiDestination(R.id.to_exit, Bundle())
        }
    }
}