package com.getmati.mati_sdk.ui.common

import android.os.Bundle
import android.view.View
import androidx.activity.OnBackPressedCallback
import com.getmati.mati_sdk.R
import com.getmati.mati_sdk.analytics.events.Clicked
import com.getmati.mati_sdk.analytics.events.UserAction
import com.getmati.mati_sdk.analytics.track
import com.getmati.mati_sdk.databinding.FragVerifiedBinding
import com.getmati.mati_sdk.mati_navigation.MatiDestination
import com.getmati.mati_sdk.ui.utils.SingleClickListener
import com.getmati.mati_sdk.ui.utils.view_binding.viewBinding
import com.getmati.mati_sdk.widgets.MatiToolbar

internal class VerificationSuccessFragment : KYCBaseFragment(R.layout.frag_verified) {

    override val screenName = "verificationSuccess"
    private val binding by viewBinding(FragVerifiedBinding::bind)

    override fun configureToolbar(toolbar: MatiToolbar) {
        super.configureToolbar(toolbar)
        toolbar.setCloseImageVisibile(false)
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        binding.actionPrimary.text = requireContext().getString(R.string.label_done)
        binding.actionPrimary.setOnClickListener {
            track(UserAction("primaryButton", Clicked(), screenName))
            mActionClickListener.onClick(it)
        }
        binding.innerTitleTvVerifiedFrag.text = requireContext().getString(R.string.label_you_are_done)

        requireActivity().onBackPressedDispatcher.addCallback(viewLifecycleOwner, object : OnBackPressedCallback(true) {
            override fun handleOnBackPressed() {
                navigation.finishVerification()
            }
        })
    }

    private val mActionClickListener: View.OnClickListener = object : SingleClickListener() {
        override fun onSingleClick(view: View) {
            navigation.finishVerification()
        }
    }

    companion object {
        fun destination(): MatiDestination {
            return MatiDestination(R.id.to_verificationSuccess, Bundle())
        }
    }
}