package com.getmati.mati_sdk.ui.data_prefetch

import android.os.Bundle
import android.view.View
import androidx.core.os.bundleOf
import androidx.fragment.app.Fragment
import androidx.lifecycle.lifecycleScope
import com.getmati.mati_sdk.R
import com.getmati.mati_sdk.databinding.FragmentDataPrefetchBinding
import com.getmati.mati_sdk.ui.verification.VerificationActivity
import com.getmati.mati_sdk.ui.start.StartVerificationFragment
import com.getmati.mati_sdk.ui.utils.view_binding.viewBinding
import kotlinx.coroutines.flow.collect
import org.koin.androidx.viewmodel.ext.android.stateViewModel

const val ARG_CLIENT_ID = "ARG_CLIENT_ID"
const val ARG_FLOW_ID = "ARG_FLOW_ID"
const val ARG_METADATA = "ARG_METADATA"

class DataPrefetchFragment : Fragment(R.layout.fragment_data_prefetch) {

    private val binding by viewBinding(FragmentDataPrefetchBinding::bind)
    private val dataPrefetchVm: DataPrefetchVm by stateViewModel(state = {
        requireActivity().intent.extras ?: bundleOf()
    })

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        binding.actionPrimary.setOnClickListener {
            dataPrefetchVm.loadFlowData()
        }
        observeVerificationDataState()
    }

    private fun observeVerificationDataState() {
        viewLifecycleOwner.lifecycleScope.launchWhenStarted {
            dataPrefetchVm.state.collect {
                when (it) {
                    is DataPrefetchVm.State.Loading -> {
                        binding.progressBar.visibility = View.VISIBLE
                        binding.errorComponents.visibility = View.INVISIBLE
                    }
                    is DataPrefetchVm.State.VerificationFlowLoading -> {
                        binding.progressBar.visibility = View.VISIBLE
                        binding.errorComponents.visibility = View.INVISIBLE
                    }
                    is DataPrefetchVm.State.ErrorState -> {
                        binding.progressBar.visibility = View.INVISIBLE
                        binding.errorComponents.visibility = View.VISIBLE
                    }
                    is DataPrefetchVm.State.Success -> {
                        val activity = (activity as? VerificationActivity) ?: return@collect
                        val navigation = activity.navigation
                        navigation.back()
                        navigation.navigateTo(StartVerificationFragment.destination())
                    }
                }
            }
        }
    }
}