package com.getmati.mati_sdk.ui.data_prefetch

import com.getmati.mati_sdk.Metadata
import com.getmati.mati_sdk.R
import com.getmati.mati_sdk.mappers.toIdToken
import com.getmati.mati_sdk.models.api.response.ApiResponse
import com.getmati.mati_sdk.models.api.response.NewAuthorizationTokenResponse
import com.getmati.mati_sdk.server.api.InitializationApi
import com.getmati.mati_sdk.ui.data_prefetch.model.Config
import com.getmati.mati_sdk.ui.data_prefetch.model.PrefetchedData
import com.getmati.mati_sdk.ui.selfie.BiometricRuntimeRepo

internal class DataPrefetchRepo(private val initializationApi: InitializationApi,
                                private val biometricRuntimeRepo: BiometricRuntimeRepo) {

    suspend fun createAuthTokenIfNeeded(clientId: String?, flowId: String?,
                                        metadata: Metadata?, config: Config?): DataPrefetchVm.State {
        val errorState = DataPrefetchVm.State.ErrorState(R.string.label_something_went_wrong)
        clientId ?: return errorState
        return when (val response = initializationApi.createAuthToken(clientId, flowId)) {
            is ApiResponse.Success -> {
                val data = response.data
                createVerificationIfNeeded(data, clientId, flowId, metadata, config)
            }
            is ApiResponse.Error -> {
                errorState
            }
        }
    }

    private suspend fun createVerificationIfNeeded(newAuthorizationTokenResponse: NewAuthorizationTokenResponse,
                                                   clientId: String, flowId: String?,
                                                   metadata: Metadata?, config: Config?): DataPrefetchVm.State {
        val accessToken = newAuthorizationTokenResponse.accessToken
        val givenIdentityId = config?.identityId
        val response = initializationApi.createVerification(accessToken, flowId, givenIdentityId, metadata)
        return when (response) {
            is ApiResponse.Success -> {
                val data = response.data
                val merchantId = newAuthorizationTokenResponse.toIdToken().merchantId
                PrefetchedData(
                    clientId = clientId,
                    accessToken = accessToken,
                    merchantId = merchantId,
                    verificationId = data.id!!,
                    identityId = data.identityId!!,
                    metadata = metadata,
                    config = config
                ).let {
                    biometricRuntimeRepo.voiceDataText = data.voiceDataText
                    DataPrefetchVm.State.VerificationCreateSuccess(it)
                }
            }
            is ApiResponse.Error -> {
                DataPrefetchVm.State.ErrorState(response.responseCode)
            }
        }
    }
}