package com.getmati.mati_sdk.ui.doc_hint

import com.getmati.mati_sdk.models.clean.verification.VerificationType
import com.getmati.mati_sdk.server.RequestKit
import com.getmati.mati_sdk.server.api.SkipApi
import com.getmati.mati_sdk.server.verification.StepVerificationResult

internal class DocHintRepository(private val requestKit: RequestKit, private val skipApi: SkipApi) {

    companion object {
        private const val TIMEOUT = 15000L
    }

    private val accessData get() = requestKit.accessData
    private val netManager get() = requestKit.netManager

    suspend fun skip(documentType: String, group: Int): StepVerificationResult<Nothing> {
        return netManager.processVerification(
            TIMEOUT,
            VerificationType.CUSTOM_DOCUMENT,
            DocHintSkipMapper(),
            null,
            true
        ) {
            skipApi.skipDoc(
                accessData.verificationId,
                VerificationType.CUSTOM_DOCUMENT.id,
                documentType,
                group
            )
        }
    }
}

