package com.getmati.mati_sdk.ui.doc_hint

import androidx.lifecycle.ViewModel
import androidx.lifecycle.viewModelScope
import com.getmati.mati_sdk.models.clean.MediaVerificationError
import com.getmati.mati_sdk.server.RequestKit
import com.getmati.mati_sdk.server.verification.VerificationError
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.flow.MutableStateFlow
import kotlinx.coroutines.flow.StateFlow
import kotlinx.coroutines.launch
import kotlinx.coroutines.withContext

internal class DocSkipVm(private val docHintRepository: DocHintRepository) : ViewModel() {

    private val _state = MutableStateFlow<State>(State.Initial)
    val state: StateFlow<State> get() = _state

    fun dropState() {
        _state.value = State.Initial
    }

    fun skip(id: String, group: Int) {
        _state.value = State.InProgress
        viewModelScope.launch(Dispatchers.IO) {
            _state.value = docHintRepository.skip(id, group).run {
                withContext(Dispatchers.Main) {
                    if (error == null || error.type == MediaVerificationError.INPUT_SKIPPED) {
                        State.SkipSuccess
                    } else {
                        State.Error(error)
                    }
                }
            }
        }
    }

    sealed class State {
        object Initial : State()
        object InProgress : State()
        object SkipSuccess : State()
        data class Error(val error: VerificationError) : State()
    }
}