package com.getmati.mati_sdk.ui.document

import com.getmati.mati_sdk.models.clean.MediaVerificationError
import com.getmati.mati_sdk.models.clean.input.Input
import com.getmati.mati_sdk.server.verification.StepVerificationResult
import com.getmati.mati_sdk.server.verification.VerificationError
import com.getmati.mati_sdk.server.verification.VerificationResultMapper
import org.json.JSONObject


internal class DocUploadMapper : VerificationResultMapper<String>() {

    override fun inputProcessedMapper(obj: JSONObject) = StepVerificationResult<String>(
            error = obj.optJSONObject("error")?.let {
                VerificationError(MediaVerificationError.byId(it.optString("code")))
            }
    )

    override fun inputJoinRoomMapper(input: Input) = StepVerificationResult<String>(
        error = if (input.inputData == null) {
            VerificationError(MediaVerificationError.OTHER)
        } else {
            null
        }
    )
}

internal class CustomDocUploadMapper : VerificationResultMapper<Nothing>() {

    override fun inputProcessedMapper(obj: JSONObject) = StepVerificationResult<Nothing>(
            error = obj.optJSONObject("error")?.let {
                VerificationError(MediaVerificationError.byId(it.optString("code")))
            }
    )

    override fun inputJoinRoomMapper(input: Input) = StepVerificationResult<Nothing>(
        error = if (input.status?.code == 200) null else VerificationError(MediaVerificationError.OTHER)
    )
}