package com.getmati.mati_sdk.ui.document

import com.getmati.mati_sdk.models.clean.CustomDoc
import com.getmati.mati_sdk.models.clean.DocPageStep
import com.getmati.mati_sdk.models.clean.verification.VerificationType
import com.getmati.mati_sdk.server.RequestKit
import com.getmati.mati_sdk.server.api.CustomDocUploadApi
import com.getmati.mati_sdk.server.api.DocumentUploadApi
import com.getmati.mati_sdk.server.verification.StepVerificationResult

internal class DocUploadRepository(private val requestKit: RequestKit,
                                   private val documentUploadApi: DocumentUploadApi,
                                   private val customDocUploadApi: CustomDocUploadApi) {

    companion object {
        private const val TIMEOUT = 15000L
    }

    private val accessData get() = requestKit.accessData
    private val netManager get() = requestKit.netManager

    suspend fun uploadDoc(docPageStep: DocPageStep<*>): StepVerificationResult<String> {
        return netManager.processVerification(
            TIMEOUT,
            VerificationType.DOCUMENT,
            DocUploadMapper(),
            docPageStep.group
        ) {
            documentUploadApi.uploadDoc(
                accessData.verificationId,
                docPageStep.filePath,
                docPageStep.docPage
            )
        }
    }

    suspend fun uploadCustomDoc(docPageStep: DocPageStep<CustomDoc>): StepVerificationResult<Nothing> {
        return netManager.processVerification(
            TIMEOUT,
            VerificationType.CUSTOM_DOCUMENT,
            CustomDocUploadMapper(),
            docPageStep.group
        ) {
            customDocUploadApi.uploadCustomDoc(
                accessData.verificationId,
                docPageStep.filePath,
                docPageStep.docPage
            )
        }
    }
}

