package com.getmati.mati_sdk.ui.document

import android.os.Bundle
import android.view.View
import android.widget.ImageView
import androidx.constraintlayout.widget.ConstraintSet
import com.getmati.mati_sdk.R
import com.getmati.mati_sdk.analytics.events.Clicked
import com.getmati.mati_sdk.analytics.events.UserAction
import com.getmati.mati_sdk.analytics.track
import com.getmati.mati_sdk.databinding.FragmentDocumentPreviewBinding
import com.getmati.mati_sdk.mati_navigation.MatiDestination
import com.getmati.mati_sdk.models.clean.DocPageStep
import com.getmati.mati_sdk.models.clean.NationalId
import com.getmati.mati_sdk.setSingleClickListener
import com.getmati.mati_sdk.ui.common.KYCBaseFragment
import com.getmati.mati_sdk.ui.utils.Util
import com.getmati.mati_sdk.ui.utils.loadImageFromFileUrl
import com.getmati.mati_sdk.ui.utils.view_binding.viewBinding
import com.getmati.mati_sdk.widgets.MatiToolbar


internal class DocumentPreviewFragment : KYCBaseFragment(R.layout.fragment_document_preview) {

    override val screenName = "documentPreview"
    private val docPageStep: DocPageStep<*> by lazy { requireArguments().getParcelable(ARG_DOC_PAGE_STEP)!! }
    private val showFrames by lazy { requireArguments().getBoolean(ARG_SHOW_FRAMES) }

    private val binding by viewBinding(FragmentDocumentPreviewBinding::bind)

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        setUpImageView()
        setUpListeners()
    }

    override fun configureToolbar(toolbar: MatiToolbar) {
        toolbar.changeTheme(MatiToolbar.Theme.NONE)
    }

    private fun setUpImageView() {
        if (!showFrames) {
            binding.overlay.visibility = View.INVISIBLE
            val constraintSet = ConstraintSet()
            constraintSet.clone(binding.root)
            constraintSet.connect(R.id.main_iv_confirt_doc_readable_frag, ConstraintSet.BOTTOM,
                    R.id.title_tv_confirm, ConstraintSet.TOP, Util.dpToPx(requireContext(), BOTTOM_MARGIN_MAIN_IV_IN_DP))
            constraintSet.applyTo(binding.root)
            binding.mainIvConfirtDocReadableFrag.scaleType = ImageView.ScaleType.FIT_CENTER
        }
        binding.mainIvConfirtDocReadableFrag.loadImageFromFileUrl(docPageStep.previewPath)
    }

    private fun setUpListeners() {
        binding.uploadIv.setSingleClickListener {
            track(UserAction("primaryButton", Clicked(), screenName))
            if(docPageStep.docPage.isFrontSide) {
                navigation.navigateTo(DocumentUploadFragment.destination(docPageStep, showFrames))
            } else {
                if(docPageStep.docPage.document.country?.code.equals(BRAZIL_COUNTRY_CODE)
                    && docPageStep.docPage.document is NationalId
                ) {
                    navigation.navigateTo(CpfEntryFragment.destination(docPageStep, showFrames))
                } else {
                    navigation.navigateTo(DocumentUploadFragment.destination(docPageStep, showFrames))
                }
            }
        }
        binding.retryIv.setSingleClickListener {
            track(UserAction("retakeButton", Clicked(), screenName))
            navigation.back()
        }
    }

    companion object {
        private const val ARG_DOC_PAGE_STEP = "ARG_DOC_PAGE"
        private const val ARG_SHOW_FRAMES = "ARG_SHOW_FRAMES"

        private const val BRAZIL_COUNTRY_CODE = "BR"

        internal const val BOTTOM_MARGIN_MAIN_IV_IN_DP = 20f

        fun destination(docPageStep: DocPageStep<*>, showFrames: Boolean = false) = MatiDestination(
                R.id.to_documentPreview,
                Bundle().apply {
                    putParcelable(ARG_DOC_PAGE_STEP, docPageStep)
                    putBoolean(ARG_SHOW_FRAMES, showFrames)
                }
        )
    }
}