package com.getmati.mati_sdk.ui.document

import android.os.Bundle
import android.view.View
import android.widget.AdapterView
import android.widget.ArrayAdapter
import com.getmati.mati_sdk.R
import com.getmati.mati_sdk.analytics.events.Clicked
import com.getmati.mati_sdk.analytics.events.UserAction
import com.getmati.mati_sdk.analytics.track
import com.getmati.mati_sdk.databinding.FragmentSelectPorTypeBinding
import com.getmati.mati_sdk.mati_navigation.MatiDestination
import com.getmati.mati_sdk.models.clean.DocPage
import com.getmati.mati_sdk.models.clean.PorType
import com.getmati.mati_sdk.models.clean.ProofOfResidency
import com.getmati.mati_sdk.ui.common.KYCBaseFragment
import com.getmati.mati_sdk.ui.utils.view_binding.viewBinding

internal class SelectPorTypeFragment : KYCBaseFragment(R.layout.fragment_select_por_type) {
    override val screenName = "SelectProofOfResidencyType"

    private val docPage: DocPage<ProofOfResidency> by lazy { requireArguments().getParcelable(ARG_DOC_PAGE)!! }
    private val group by lazy { requireArguments().getInt(ARG_DOCUMENT_GROUP) }
    private val binding by viewBinding(FragmentSelectPorTypeBinding::bind)

    private lateinit var mPorType: PorType

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        mPorType = savedInstanceState?.getString(ARG_POR_TYPE)?.let { PorType.valueOf(it) }
            ?: PorType.UTILITY_BILL
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        setUpSpinner()

        docPage.document.apply {
            binding.titleTv.text = getDocTitle(docPage.document)
            binding.subtitleTv.text = if (region.isNullOrEmpty()) {
                String.format("%s", country!!.name)
            } else {
                String.format("%s, %s", country!!.name, region)
            }
        }

        binding.actionPrimary.setOnClickListener {
            track(UserAction("primaryButton", Clicked(), screenName))
            val result = docPage.run { copy(document = document.copy(porType = mPorType)) }
            navigation.navigateTo(ProofOfResidenceHintFragment.destination(result, group))
        }
    }

    private fun setUpSpinner() {
        val porOptionsSp = binding.porOptionsSp
        val types = PorType.values()
        val adapter = ArrayAdapter(
            requireContext(),
            R.layout.item_por_type,
            types.map { getString(it.titleRes) }
        )
        porOptionsSp.adapter = adapter
        porOptionsSp.setSelection(types.indexOf(mPorType))

        porOptionsSp.onItemSelectedListener = object : AdapterView.OnItemSelectedListener {
            override fun onNothingSelected(parent: AdapterView<*>?) {}
            override fun onItemSelected(parent: AdapterView<*>?, view: View?, position: Int, id: Long) {
                mPorType = types[position]
            }
        }
    }

    override fun onSaveInstanceState(outState: Bundle) {
        super.onSaveInstanceState(outState)
        outState.putString(ARG_POR_TYPE, mPorType.name)
    }

    companion object {
        private const val ARG_DOC_PAGE = "ARG_DOC_PAGE"
        private const val ARG_DOCUMENT_GROUP = "ARG_DOCUMENT_GROUP"

        private const val ARG_POR_TYPE = "ARG_DOCUMENT_TYPE"

        @JvmStatic
        fun destination(docPage: DocPage<ProofOfResidency>, group: Int) = MatiDestination(
                R.id.to_selectPorTypeFragment,
                Bundle().apply {
                    putParcelable(ARG_DOC_PAGE, docPage)
                    putInt(ARG_DOCUMENT_GROUP, group)
                })
    }
}