package com.getmati.mati_sdk.ui.email

import androidx.lifecycle.SavedStateHandle
import androidx.lifecycle.ViewModel
import com.getmati.mati_sdk.ui.email.email_validation.EmailVerificationFragment

internal class EmailSharedVm(
        private val savedState: SavedStateHandle
) : ViewModel() {

    companion object {
        private const val ARG_RESEND_COUNT = "ARG_RESEND_COUNT"
        private const val ARG_CODE_ATTEMPT_COUNT = "ARG_CODE_ATTEMPT_COUNT"

        private const val ARG_RESEND_BLOCKED_UNTIL = "ARG_LAST_RESEND"
        private const val ARG_LAST_EMAIL = "ARG_LAST_EMAIL"
        private const val ARG_COOL_DOWN = EmailVerificationFragment.ARG_COOL_DOWN
        private const val RESEND_LIMIT = 5
        private const val CODE_ATTEMPT_LIMIT = 3
    }

    private val coolDown = savedState.get<Long>(ARG_COOL_DOWN)!!

    var lastEmail
        get() = savedState.get<String>(ARG_LAST_EMAIL)
        private set(value) {
            savedState.set(ARG_LAST_EMAIL, value)
        }

    var resendCount
        get() = savedState.get<Int>(ARG_RESEND_COUNT) ?: 0
        private set(value) {
            if (value < 0 || value > RESEND_LIMIT) return
            savedState.set(ARG_RESEND_COUNT, value)
        }

    fun increaseResendCount() {
        resendCount++
    }

    fun lockResendCount() {
        resendCount = RESEND_LIMIT
    }

    val resendLocked get() = resendCount == RESEND_LIMIT

    var codeAttemptCount
        get() = savedState.get<Int>(ARG_CODE_ATTEMPT_COUNT) ?: 0
        private set(value) {
            if (value < 0 || value > RESEND_LIMIT) return
            savedState.set(ARG_CODE_ATTEMPT_COUNT, value)
        }

    fun increaseCodeAttemptsCount() {
        codeAttemptCount++
    }

    fun resetCodeAttemptsCount() {
        codeAttemptCount = 0
    }

    fun lockCodeAttemptsCount() {
        codeAttemptCount = CODE_ATTEMPT_LIMIT
    }

    val codeAttemptLocked get() = codeAttemptCount == CODE_ATTEMPT_LIMIT

    var coolDownUntil
        get() = savedState.get<Long>(ARG_RESEND_BLOCKED_UNTIL) ?: 0
        set(value) {
            savedState.set(ARG_RESEND_BLOCKED_UNTIL, value)
        }

    private fun updateCoolDownValue() {
        coolDownUntil = System.currentTimeMillis() + coolDown
    }

    fun resendIsAllowed() = System.currentTimeMillis() > coolDownUntil

    fun onNewEmailSubmitted(email: String) {
        lastEmail = email
        onCodeSent()
    }

    fun onCodeSent() {
        resetCodeAttemptsCount()
        increaseResendCount()
        updateCoolDownValue()
    }
}