package com.getmati.mati_sdk.ui.email

import com.getmati.mati_sdk.models.clean.verification.VerificationType
import com.getmati.mati_sdk.server.RequestKit
import com.getmati.mati_sdk.server.api.EmailProcessApi
import com.getmati.mati_sdk.server.api.SkipApi
import com.getmati.mati_sdk.server.verification.StepVerificationResult

internal class EmailVerificationRepository(private val requestKit: RequestKit,
                                           private val emailProcessApi: EmailProcessApi,
                                           private val skipApi: SkipApi) {

    companion object {
        private const val TIMEOUT = 15000L
    }

    private val accessData get() = requestKit.accessData
    private val netManager get() = requestKit.netManager

    suspend fun submitEmail(email: String): StepVerificationResult<String> {
        return netManager.processVerification(
            TIMEOUT,
            VerificationType.EMAIL_VERIFICATION,
            EmailSubmissionMapper()
        ) {
            emailProcessApi.submitEmail(accessData.verificationId, email)
        }.copy(data = email)
    }

    suspend fun verifyEmail(email: String, code: String): StepVerificationResult<Nothing> {
        return netManager.processVerification(
            TIMEOUT,
            VerificationType.EMAIL_VERIFICATION,
            EmailVerificationMapper()
        ) {
            emailProcessApi.verifyEmail(accessData.verificationId, email, code)
        }
    }

    suspend fun skip(): StepVerificationResult<Nothing> {
        return netManager.processVerification(
            TIMEOUT,
            VerificationType.EMAIL_VERIFICATION,
            EmailVerificationMapper(),
            null,
            true
        ) {
            skipApi.skip(accessData.verificationId, VerificationType.EMAIL_VERIFICATION.id)
        }
    }
}

