package com.getmati.mati_sdk.ui.error

import android.os.Bundle
import android.view.View
import androidx.core.os.bundleOf
import com.getmati.mati_sdk.R
import com.getmati.mati_sdk.analytics.events.Clicked
import com.getmati.mati_sdk.analytics.events.UserAction
import com.getmati.mati_sdk.analytics.track
import com.getmati.mati_sdk.databinding.FragmentBaseErrorBinding
import com.getmati.mati_sdk.mati_navigation.MatiDestination
import com.getmati.mati_sdk.ui.common.KYCBaseFragment
import com.getmati.mati_sdk.ui.utils.loadImageResource
import com.getmati.mati_sdk.ui.utils.view_binding.viewBinding

internal class BaseErrorFragment : KYCBaseFragment(R.layout.fragment_base_error) {
    override val screenName: String by lazy { errorData.analytics.errorScreenName }

    private val errorData: ErrorScreenInputData by lazy {
        requireArguments().getParcelable(ErrorScreenConstants.ERROR_FRAGMENT_INPUT_DATA_KEY)
            ?: defaultErrorData()
    }

    private val primaryButtonAnalyticsName: String by lazy { errorData.analytics.primaryButtonName }

    private val binding by viewBinding(FragmentBaseErrorBinding::bind)


    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)

        binding.iconError.loadImageResource(errorData.drawableResource)
        binding.labelTitleError.text = errorData.heading
        binding.labelSubtitleError.text = errorData.subHeading
        binding.actionPrimary.text = errorData.primaryButtonName
        binding.actionPrimary.setOnClickListener {
            track(UserAction(primaryButtonAnalyticsName, Clicked(), screenName))
            navigation.back()
        }
    }

    private fun defaultErrorData() = prepareBaseErrorScreenData(
        R.drawable.ic_error_other,
        requireContext().getString(R.string.label_something_went_wrong),
        requireContext().getString(R.string.label_check_your_internet),
        requireContext().getString(R.string.label_try_again),
    )

    companion object {

        fun destination(fragmentArgument: ErrorScreenInputData): MatiDestination {
            return MatiDestination(
                R.id.to_ErrorFragment,
                bundleOf(ErrorScreenConstants.ERROR_FRAGMENT_INPUT_DATA_KEY to fragmentArgument)
            )
        }
    }
}