package com.getmati.mati_sdk.ui.error

import android.os.Parcelable
import androidx.annotation.DrawableRes
import com.getmati.mati_sdk.R
import kotlinx.parcelize.Parcelize

@Parcelize
data class ErrorScreenInputData(
    @DrawableRes val drawableResource: Int = R.drawable.ic_error_other,
    val heading: String,
    val subHeading: String?,
    val primaryButtonName: String,
    val analytics: ErrorScreenAnalyticsData
) : Parcelable

@Parcelize
data class ErrorScreenAnalyticsData(
    val primaryButtonName: String,
    val errorScreenName: String
) : Parcelable

fun getMediaErrorScreenAnalytics() = ErrorScreenAnalyticsData(
    ErrorScreenConstants.ANALYTICS_SCREEN_NAME_MEDIA_ERROR_PRIMARY_BUTTON,
    ErrorScreenConstants.ANALYTICS_SCREEN_NAME_MEDIA_ERROR
)


fun getMediaProcessingErrorScreenAnalytics() = ErrorScreenAnalyticsData(
    ErrorScreenConstants.ANALYTICS_SCREEN_NAME_MEDIA_PROCESS_ERROR_PRIMARY_BUTTON,
    ErrorScreenConstants.ANALYTICS_SCREEN_NAME_MEDIA_PROCESS_ERROR
)

fun getBaseErrorScreenAnalytics() = ErrorScreenAnalyticsData(
    ErrorScreenConstants.ANALYTICS_SCREEN_NAME_UPLOAD_ERROR_PRIMARY_BUTTON,
    ErrorScreenConstants.ANALYTICS_SCREEN_NAME_UPLOAD_ERROR
)

internal fun prepareMediaErrorScreenData(
    @DrawableRes icon: Int = R.drawable.ic_error_other,
    title: String,
    subHeading: String = "",
    primaryCTALabel: String, //= context.getString(R.string.label_try_again),
    analyticsData: ErrorScreenAnalyticsData = getMediaErrorScreenAnalytics()
) = ErrorScreenInputData(
    icon,
    title,
    subHeading,
    primaryCTALabel,
    analyticsData
)

internal fun prepareMediaProcessingErrorScreenData(
    @DrawableRes iconId: Int,
    errorString: String,
    errorDescription: String,
    primaryCTALabel: String,
    analyticsData: ErrorScreenAnalyticsData = getMediaProcessingErrorScreenAnalytics()
) = ErrorScreenInputData(
    iconId,
    errorString,
    errorDescription,
    primaryCTALabel,
    analyticsData
)

internal fun prepareBaseErrorScreenData(
    @DrawableRes iconId: Int,
    error: String,
    errorDescription: String,
    primaryCTALabel: String,
    analytics: ErrorScreenAnalyticsData = getBaseErrorScreenAnalytics(),
) = ErrorScreenInputData(
    iconId,
    error,
    errorDescription,
    primaryCTALabel,
    analytics
)