package com.getmati.mati_sdk.ui.esign

import android.os.Bundle
import androidx.core.os.bundleOf
import androidx.fragment.app.commit
import androidx.lifecycle.coroutineScope
import com.getmati.mati_sdk.R
import com.getmati.mati_sdk.mati_navigation.MatiDestination
import com.getmati.mati_sdk.ui.ESignVerificationStep
import com.getmati.mati_sdk.ui.common.KYCBaseFragment
import com.getmati.mati_sdk.ui.error.BaseErrorFragment
import com.getmati.mati_sdk.ui.error.prepareMediaErrorScreenData
import com.getmati.mati_sdk.ui.esign.model.State
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.flow.collect
import kotlinx.coroutines.launch
import kotlinx.coroutines.withContext
import org.koin.androidx.viewmodel.ext.android.viewModel

internal class ESignHostFragment : KYCBaseFragment(R.layout.fragment_e_sign_host) {

    override val screenName = "pleaseReadCarefullyHost"

    val eSignVM by viewModel<ESignVM>()

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        val verificationSteps = verificationFlow.verificationSteps
        val eSign = verificationSteps.filterIsInstance<ESignVerificationStep>().first()
        eSignVM.setVerificationStep(eSign)

        lifecycle.coroutineScope.launch {
            eSignVM.navigationFlow.collect { index ->
                withContext(Dispatchers.Main) {
                    childFragmentManager.commit {
                        val signDocFragment = SignDocFragment.newInstance(index)
                        add(
                            R.id.fragmentContainer,
                            signDocFragment,
                            signDocFragment::class.java.name
                        )
                    }
                }
            }
        }
        lifecycle.coroutineScope.launch {
            eSignVM.verificationStateFlow.collect {
                withContext(Dispatchers.Main) {
                    when (it) {
                        is State.SignSuccess -> {
                            navigation.openNextStep()
                        }
                        is State.Error -> {
                            val error = it.error.type
                            navigation.navigateTo(
                                BaseErrorFragment.destination(
                                    prepareMediaErrorScreenData(
                                        title = getString(error.title),
                                        subHeading = getString(error.subtitle),
                                        primaryCTALabel = getString(R.string.label_try_again)
                                    )
                                )
                            )
                        }
                    }
                }
            }
        }
    }

    companion object {

        @JvmStatic
        fun destination(): MatiDestination {
            return MatiDestination(R.id.to_please_read_carefully, bundleOf())
        }
    }
}