package com.getmati.mati_sdk.ui.esign

import android.app.Application
import com.getmati.mati_sdk.managers.prefetch.PrefetchDataHolder
import com.getmati.mati_sdk.models.api.response.ApiResponse
import com.getmati.mati_sdk.models.clean.verification.VerificationType
import com.getmati.mati_sdk.server.RequestKit
import com.getmati.mati_sdk.server.api.ESignApi
import com.getmati.mati_sdk.server.api.MediaDownloadApi
import com.getmati.mati_sdk.server.verification.StepVerificationResult
import com.getmati.mati_sdk.ui.esign.model.DocToSign
import java.io.File
import java.text.SimpleDateFormat
import java.util.*

internal class ESignRepo(
    application: Application,
    private val eSignApi: ESignApi,
    private val requestKit: RequestKit,
    private val mediaDownloadApi: MediaDownloadApi,
    private val prefetchDataHolder: PrefetchDataHolder) {

    private val pdfDirectory = File("${application.cacheDir}/esign")

    suspend fun downloadDoc(docToSign: DocToSign): String? {
        val url = docToSign.url.substringAfter("location=")
        val response = mediaDownloadApi.downloadMedia(url)
        if (response is ApiResponse.Success) {
            val byteArrayResponse = response.data
            pdfDirectory.mkdirs()
            val file = File.createTempFile(docToSign.id, ".pdf", pdfDirectory)
            file.writeBytes(byteArrayResponse)
            return file.path
        }

        return null
    }

    suspend fun accept(name: String, signedDocs: Map<String, String>): StepVerificationResult<String> {
        val prefetchedData = prefetchDataHolder.prefetchedData
        val verificationId = prefetchedData.verificationId

        return requestKit.netManager.processVerification(
            15_000L,
            VerificationType.E_SIGN,
            ESignMapper()
        ) { eSignApi.accept(verificationId, name, signedDocs) }
    }

    fun next(docToSign: DocToSign): Pair<String, String> {
        val timestamp =
            SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.getDefault()).apply {
                TimeZone.getTimeZone("GMT")
            }.format(Date())
        return docToSign.id to timestamp
    }

    fun clearPdfDir() {
        pdfDirectory.mkdirs()
        pdfDirectory.deleteRecursively()
    }
}
