package com.getmati.mati_sdk.ui.esign.model

import com.getmati.mati_sdk.server.verification.VerificationError

sealed class State {
    internal object None : State()
    internal object Loading : State()
    internal object SignSuccess : State()
    internal data class Success(val pdfPath: String) : State()
    internal data class Error(val error: VerificationError) : State()
    internal object ErrorDownloadPdf : State()
}