package com.getmati.mati_sdk.ui.iprestrictions

import android.os.Bundle
import android.view.View
import androidx.activity.OnBackPressedCallback
import androidx.lifecycle.lifecycleScope
import com.getmati.mati_sdk.R
import com.getmati.mati_sdk.databinding.FragmentIpCountryRestrictedBinding
import com.getmati.mati_sdk.mati_navigation.MatiDestination
import com.getmati.mati_sdk.ui.common.ExitFragment
import com.getmati.mati_sdk.ui.common.KYCBaseFragment
import com.getmati.mati_sdk.ui.utils.view_binding.viewBinding
import com.getmati.mati_sdk.widgets.MatiToolbar
import kotlinx.coroutines.flow.collect
import kotlinx.coroutines.launch

internal class IpCountryRestrictedFragment: KYCBaseFragment(R.layout.fragment_ip_country_restricted) {
    override val screenName by lazy { "ipRestrictionError" }
    private val isCritical by lazy { requireArguments().getBoolean(ARG_CRITICAL) }
    private val binding by viewBinding(FragmentIpCountryRestrictedBinding::bind)

    override fun configureToolbar(toolbar: MatiToolbar) {
        super.configureToolbar(toolbar)
        toolbar.setBackImageVisibile(false)
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        binding.actionClose.run {
            visibility = if(isCritical) View.VISIBLE else View.GONE
            setOnClickListener{ navigation.navigateTo(ExitFragment.destination()) }
            requireActivity().onBackPressedDispatcher.addCallback(viewLifecycleOwner, object : OnBackPressedCallback(true) {
                override fun handleOnBackPressed() {
                    navigation.navigateTo(ExitFragment.destination())
                }
            })
        }
        binding.actionSkip.run {
            visibility = if (!isCritical) View.VISIBLE else View.GONE
            setOnClickListener { navigation.openVerificationStep(0) }
        }

        viewLifecycleOwner.lifecycleScope.launch {
            verificationVm.inputsFlow.collect { inputs ->
                inputs.firstOrNull { it.id == "connection-data" }?.error.let {
                    if(it?.code != "connectionData.restricted") {
                        navigation.back()
                    }
                }
            }
        }
    }

    companion object {
        const val ARG_CRITICAL = "ARG_CRITICAL"

        fun destination(isCritical: Boolean): MatiDestination {
            return MatiDestination(R.id.to_ip_country_restricted, Bundle().apply {
                putBoolean(ARG_CRITICAL, isCritical)
            })
        }
    }
}