package com.getmati.mati_sdk.ui.iprestrictions

import com.getmati.mati_sdk.models.clean.MediaVerificationError
import com.getmati.mati_sdk.models.clean.input.Input
import com.getmati.mati_sdk.server.verification.ErrorDetails
import com.getmati.mati_sdk.server.verification.StepVerificationResult
import com.getmati.mati_sdk.server.verification.VerificationError
import com.getmati.mati_sdk.server.verification.VerificationResultMapper
import org.json.JSONObject

internal class VpnDetectMapper : VerificationResultMapper<Nothing>() {

    override fun inputProcessedMapper(obj: JSONObject) = StepVerificationResult<Nothing>(
        error = obj.optJSONObject("error")?.let {
            VerificationError(
                MediaVerificationError.byId(it.optString("code")), ErrorDetails.RestrictionErrorDetails(
                optional = it.optBoolean("optional", false),
                triesCount = it.optJSONObject("details")?.optInt("attemptsLeft", 0) ?: 0
            ))
        }
    )

    override fun inputJoinRoomMapper(input: Input) = StepVerificationResult<Nothing>(
        error = if (input.status?.code == 200) {
            null
        } else {
            VerificationError(
                MediaVerificationError.CONNECTION_DATA_VPM_DETECTED,
                ErrorDetails.RestrictionErrorDetails(
                    optional = input.error?.optional ?: false,
                    triesCount = input.error?.inputErrorDetail?.attemptsLeft ?: 0
                )
            )
        }
    )
}