package com.getmati.mati_sdk.ui.iprestrictions

import androidx.lifecycle.ViewModel
import androidx.lifecycle.viewModelScope
import com.getmati.mati_sdk.managers.prefetch.PrefetchDataHolder
import com.getmati.mati_sdk.models.clean.MediaVerificationError
import com.getmati.mati_sdk.models.clean.verification.VerificationType
import com.getmati.mati_sdk.server.RequestKit
import com.getmati.mati_sdk.server.api.ConnectionApi
import com.getmati.mati_sdk.server.verification.ErrorDetails
import com.getmati.mati_sdk.server.verification.VerificationError
import kotlinx.coroutines.flow.MutableStateFlow
import kotlinx.coroutines.flow.StateFlow
import kotlinx.coroutines.launch

internal class VpnDetectedVM(private val requestKit: RequestKit,
                             private val connectionApi: ConnectionApi,
                             private val prefetchDataHolder: PrefetchDataHolder) : ViewModel() {

    private val error = VerificationError(
        MediaVerificationError.CONNECTION_DATA_VPM_DETECTED,
        ErrorDetails.RestrictionErrorDetails(false, 3)
    )
    private val mutableStateFlow = MutableStateFlow<State>(State.Loaded(error))

    val stateFlow: StateFlow<State>
        get() {
            return mutableStateFlow
        }

    fun tryAgain() {
        mutableStateFlow.value = State.Loading
        viewModelScope.launch {
            val result = requestKit.netManager.processVerification(
                15_000L,
                VerificationType.CONNECTION_DATA,
                VpnDetectMapper()
            ) { connectionApi.connect(prefetchDataHolder.prefetchedData.verificationId) }

            mutableStateFlow.value = if (result.error?.type == MediaVerificationError.OTHER) {
                State.Loaded(null)
            } else {
                State.Loaded(result.error)
            }
        }
    }

    sealed class State {
        data class Loaded(val error: VerificationError?) : State()
        object Loading : State()
    }
}