package com.getmati.mati_sdk.ui.liveness

import android.graphics.SurfaceTexture
import android.media.MediaPlayer
import android.os.Bundle
import android.view.Surface
import android.view.TextureView
import android.view.View
import androidx.core.net.toUri
import com.getmati.mati_sdk.R
import com.getmati.mati_sdk.analytics.events.Clicked
import com.getmati.mati_sdk.analytics.events.UserAction
import com.getmati.mati_sdk.analytics.track
import com.getmati.mati_sdk.centerCropMirrored
import com.getmati.mati_sdk.databinding.FragmentLivenessPreviewBinding
import com.getmati.mati_sdk.mati_navigation.MatiDestination
import com.getmati.mati_sdk.setSingleClickListener
import com.getmati.mati_sdk.ui.BiometryType
import com.getmati.mati_sdk.ui.common.KYCBaseFragment
import com.getmati.mati_sdk.ui.utils.view_binding.viewBinding
import com.getmati.mati_sdk.widgets.MatiToolbar

internal class LivenessPreviewFragment : KYCBaseFragment(R.layout.fragment_liveness_preview) {
    override val screenName get() = "LivenessPreview"

    private val path by lazy { requireArguments().getString(ARG_VIDEO_PATH)!! }
    private val isFrontLens by lazy { requireArguments().getBoolean(ARG_FRONT_LENS) }
    private val binding by viewBinding(FragmentLivenessPreviewBinding::bind)

    override fun configureToolbar(toolbar: MatiToolbar) {
        toolbar.changeTheme(MatiToolbar.Theme.NONE)
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        setUpViews()
    }

    private var mediaPlayer: MediaPlayer? = null
    private fun setUpViews() {
        binding.uploadIv.setSingleClickListener {
            track(UserAction("uploadButton", Clicked(), screenName))
            val position = mediaPlayer?.currentPosition ?: 0
            mediaPlayer?.release()
            mediaPlayer = null
            navigation.navigateTo(
                VideoUploadFragment.destination(
                    path,
                    position,
                    isFrontLens,
                    BiometryType.SELFIE_VIDEO
                )
            )
        }
        binding.playIv.setSingleClickListener {
            track(UserAction("playButton", Clicked(), screenName))
            binding.playIv.visibility = View.INVISIBLE
            mediaPlayer?.start()
        }
        binding.retryIv.setSingleClickListener { navigation.back() }
        binding.textureView.surfaceTextureListener = object : TextureView.SurfaceTextureListener {

             override fun onSurfaceTextureAvailable(surface: SurfaceTexture, width: Int, height: Int) {
                val s = Surface(surface)
                mediaPlayer = MediaPlayer().apply {
                    setVolume(0f, 0f)
                    setSurface(s)
                    setDataSource(requireContext(), path.toUri())
                    setOnPreparedListener {
                        binding.textureView.centerCropMirrored(it, isFrontLens)
                        it.start()
                    }
                    setOnCompletionListener {
                        if (view == null) {
                            return@setOnCompletionListener
                        }
                        binding.playIv.visibility = View.VISIBLE
                    }
                    prepare()
                }
            }

            override fun onSurfaceTextureSizeChanged(surface: SurfaceTexture, width: Int, height: Int) {}
            override fun onSurfaceTextureDestroyed(surface: SurfaceTexture) = true
            override fun onSurfaceTextureUpdated(surface: SurfaceTexture) {}
        }
    }

    companion object {
        private const val ARG_VIDEO_PATH = "ARG_VIDEO_PATH"
        private const val ARG_FRONT_LENS = "ARG_FRONT_LENS"

        fun destination(path: String, isFrontLens: Boolean) = MatiDestination(
            R.id.to_liveness_preview,
            Bundle().apply {
                putString(ARG_VIDEO_PATH, path)
                putBoolean(ARG_FRONT_LENS, isFrontLens)
            }
        )
    }
}
