package com.getmati.mati_sdk.ui.liveness

import androidx.lifecycle.ViewModel
import androidx.lifecycle.viewModelScope
import com.getmati.mati_sdk.models.clean.MediaVerificationError
import com.getmati.mati_sdk.server.verification.ErrorDetails
import com.getmati.mati_sdk.server.verification.VerificationError
import com.getmati.mati_sdk.ui.selfie.BiometricRuntimeRepo
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.flow.MutableStateFlow
import kotlinx.coroutines.flow.StateFlow
import kotlinx.coroutines.launch


internal class VideoUploadVm(
    private val videoRepo: VideoRepo,
    private val path: String,
    private val biometricRuntimeRepo: BiometricRuntimeRepo
) : ViewModel() {

    private val _state = MutableStateFlow<State>(State.Uploading)
    val state: StateFlow<State> = _state

    init {
        viewModelScope.launch(Dispatchers.IO) {
            _state.value = videoRepo.upload(path).let { it ->
                if (it.error == null || it.error.type == MediaVerificationError.INPUT_LOCKED) {
                    State.Success
                } else {
                    (it.error.details as? ErrorDetails.VoiceLivenessErrorDetails)?.text
                        ?.let { biometricRuntimeRepo.voiceDataText = it }
                    State.Error(it.error)
                }
            }
        }
    }

    sealed class State {
        object Uploading : State()
        data class Error(val error: VerificationError) : State()
        object Success : State()
    }
}