package com.getmati.mati_sdk.ui.liveness

import com.getmati.mati_sdk.models.clean.verification.VerificationType
import com.getmati.mati_sdk.server.RequestKit
import com.getmati.mati_sdk.server.api.VoiceLivenessUploadApi
import com.getmati.mati_sdk.server.verification.StepVerificationResult

internal class VoiceLivenessRepo(private val requestKit: RequestKit,
                                 private val voiceLivenessUploadApi: VoiceLivenessUploadApi) : VideoRepo {

    companion object {
        private const val TIMEOUT = 120_000L
    }

    override suspend fun upload(path: String): StepVerificationResult<Nothing> {
        return requestKit.netManager.processVerification(
            TIMEOUT,
            VerificationType.VOICE_LIVENESS,
            VoiceLivenessVerificationMapper()
        ) {
            voiceLivenessUploadApi.uploadVoiceLiveness(requestKit.accessData.verificationId, path)
        }
    }
}

