package com.getmati.mati_sdk.ui.liveness

import com.getmati.mati_sdk.models.clean.MediaVerificationError
import com.getmati.mati_sdk.models.clean.input.Input
import com.getmati.mati_sdk.server.verification.ErrorDetails
import com.getmati.mati_sdk.server.verification.StepVerificationResult
import com.getmati.mati_sdk.server.verification.VerificationError
import com.getmati.mati_sdk.server.verification.VerificationResultMapper
import org.json.JSONObject

internal class VoiceLivenessVerificationMapper : VerificationResultMapper<Nothing>() {

    override fun inputProcessedMapper(obj: JSONObject) = StepVerificationResult<Nothing>(
        error = obj.optJSONObject("error")?.let {
            VerificationError(
                type = MediaVerificationError.byId(it.optString("code")),
                details = it.optJSONObject("details")?.optString("text")?.let{ text->
                    ErrorDetails.VoiceLivenessErrorDetails(text)
                }
            )
        }
    )

    override fun inputJoinRoomMapper(input: Input) = StepVerificationResult<Nothing>(
        error = if (input.status?.code == 200) null else VerificationError(MediaVerificationError.OTHER)
    )
}