package com.getmati.mati_sdk.ui.media.view

import android.content.Context
import android.graphics.Matrix
import android.graphics.SurfaceTexture
import android.util.AttributeSet
import android.view.TextureView
import androidx.lifecycle.LifecycleOwner
import androidx.lifecycle.MutableLiveData

internal class PreviewView @JvmOverloads constructor(context: Context, attrs: AttributeSet? = null, defStyle: Int = 0) : TextureView(context, attrs, defStyle) {
    private val surfaceObservable = MutableLiveData<SurfaceTexture?>()

    init {
        surfaceTextureListener = object : SurfaceTextureListener {
            override fun onSurfaceTextureAvailable(surface: SurfaceTexture, width: Int, height: Int) {
                // Do nothing
                surfaceObservable.value = surface
            }

            override fun onSurfaceTextureSizeChanged(surface: SurfaceTexture, width: Int, height: Int) {
                // Do nothing
            }

            override fun onSurfaceTextureDestroyed(surface: SurfaceTexture): Boolean {
                surfaceObservable.value = null
                return true
            }

            override fun onSurfaceTextureUpdated(surface: SurfaceTexture) {
                // Do nothing
            }
        }
    }

    private fun configureTransform(videoWidth: Int, videoHeight: Int) {
        val videoWidthF = videoHeight.toFloat()
        val videoHeightF = videoWidth.toFloat()

        val videoRatio = videoHeightF / videoWidthF

        val viewWidth = this.width.toFloat()
        val viewHeight = this.height.toFloat()

        val viewRatio = viewHeight / viewWidth

        setTransform(Matrix().apply {
            val sx = viewHeight / videoWidth
            val sy = viewWidth / videoHeight
            if(videoRatio < viewRatio) {
                setScale(  sx / sy, 1f, viewWidth / 2f, viewHeight / 2f)
            } else {
                setScale(  1f, sy / sx, viewWidth / 2f, viewHeight / 2f)
            }
        })
    }

    fun setCameraDimensions(width: Int, height: Int) {
        surfaceTexture?.setDefaultBufferSize(width, height)
        configureTransform(width, height)
    }

    fun observeSurfaceOnce(lifecycle: LifecycleOwner, onSurfaceAvailable: (surface : SurfaceTexture?) -> Unit) {
        surfaceObservable.observe(lifecycle) {
            onSurfaceAvailable(it)
            surfaceObservable.removeObserver(onSurfaceAvailable)
        }
    }

    companion object {
        private const val TAG = "AutoFitTextureView"
    }
}