package com.getmati.mati_sdk.ui.permission_denial

import android.Manifest
import android.content.Intent
import android.net.Uri
import android.os.Bundle
import android.provider.Settings
import android.view.View
import com.getmati.mati_sdk.R
import com.getmati.mati_sdk.databinding.FragmentPermissionDenialInfoBinding
import com.getmati.mati_sdk.hasAudioPermission
import com.getmati.mati_sdk.hasCameraPermission
import com.getmati.mati_sdk.mati_navigation.MatiDestination
import com.getmati.mati_sdk.setSingleClickListener
import com.getmati.mati_sdk.ui.common.KYCBaseFragment
import com.getmati.mati_sdk.ui.utils.loadImageResource
import com.getmati.mati_sdk.ui.utils.view_binding.viewBinding

internal class PermissionDenialInfoFragment : KYCBaseFragment(R.layout.fragment_permission_denial_info) {

    override val screenName get() = "permissionDenialInfo"
    private val permission by lazy { requireArguments().getString(ARG_PERMISSION)!! }
    private val binding by viewBinding(FragmentPermissionDenialInfoBinding::bind)

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        setValues()
        setListeners()
    }

    private fun setValues() {
        when (permission) {
            Manifest.permission.CAMERA -> {
                binding.iconError.loadImageResource(R.drawable.ic_camera_access_denied)
                binding.labelTitleError.text = getString(R.string.title_camera_permission_denied)
                binding.labelSubtitleError.text = getString(R.string.subtitle_camera_permission_denied)
            }
            Manifest.permission.RECORD_AUDIO -> {
                binding.iconError.loadImageResource(R.drawable.ic_microphone_access_denied)
                binding.labelTitleError.text = getString(R.string.title_microphone_permission_denied)
                binding.labelSubtitleError.text = getString(R.string.subtitle_microphone_permission_denied)
            }
        }
    }

    private fun setListeners() {
        binding.actionPrimary.setSingleClickListener {
            val intent = Intent(Settings.ACTION_APPLICATION_DETAILS_SETTINGS)
                    .apply { data = Uri.fromParts("package", requireContext().packageName, null) }
            startActivity(intent)
        }
    }

    override fun onStart() {
        super.onStart()
        when (permission) {
            Manifest.permission.CAMERA -> if (requireContext().hasCameraPermission()) navigation.back()
            Manifest.permission.RECORD_AUDIO -> if (requireContext().hasAudioPermission()) navigation.back()
        }
    }

    companion object {
        private const val ARG_PERMISSION = "ARG_PERMISSION"

        fun destination(permission: String): MatiDestination {
            return MatiDestination(R.id.to_permissionDenialInfoFragment, Bundle().apply {
                putString(ARG_PERMISSION, permission)
            })
        }
    }
}