package com.getmati.mati_sdk.ui.phonevalidation

import android.os.Bundle
import android.view.View
import androidx.activity.OnBackPressedCallback
import com.getmati.mati_sdk.R
import com.getmati.mati_sdk.databinding.FragmentAttemptsExhaustedBinding
import com.getmati.mati_sdk.mati_navigation.MatiDestination
import com.getmati.mati_sdk.ui.common.KYCBaseFragment
import com.getmati.mati_sdk.ui.utils.loadImageResource
import com.getmati.mati_sdk.ui.utils.view_binding.viewBinding
import com.getmati.mati_sdk.widgets.MatiToolbar

internal class AttemptsExhaustedFragment : KYCBaseFragment(R.layout.fragment_attempts_exhausted) {
    override val screenName = "error"
    private val verificationType by lazy { Error.valueOf(requireArguments().getString(ARG_VERIFICATION_TYPE)!!) }

    private val binding by viewBinding(FragmentAttemptsExhaustedBinding::bind)

    override fun configureToolbar(toolbar: MatiToolbar) {
        super.configureToolbar(toolbar)
        toolbar.setBackImageVisibile(false)
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        setUpListeners()
        setUpViews()
    }

    private fun setUpListeners() {
        binding.actionPrimary.setOnClickListener {
            navigation.cancelVerification()
        }
        requireActivity().onBackPressedDispatcher.addCallback(viewLifecycleOwner, object : OnBackPressedCallback(true) {
            override fun handleOnBackPressed() {}
        })
    }

    private fun setUpViews() {
        when (verificationType) {
            Error.INVALID_CONFIGURATION -> {
                binding.actionPrimary.text = getString(R.string.label_close)
                binding.titleTv.text = getString(R.string.label_something_went_wrong)
                binding.mainIv.loadImageResource(R.drawable.ic_error_other)
            }
            Error.EMAIL_VERIFICATION_ATTEMPTS_EXHAUSTED -> {
                binding.actionPrimary.text = getString(R.string.label_close)
                binding.titleTv.text = getString(R.string.error_description_too_many_resends)
                binding.mainIv.loadImageResource(R.drawable.ic_email_verification_step)
            }
            Error.PHONE_VERIFICATION_ATTEMPTS_EXHAUSTED -> {
                binding.actionPrimary.text = getString(R.string.label_cancel_button)
                binding.titleTv.text = getString(R.string.label_sms_check_noattemps)
                binding.mainIv.loadImageResource(R.drawable.img_phone)
            }
        }
    }

    enum class Error {
        INVALID_CONFIGURATION,
        EMAIL_VERIFICATION_ATTEMPTS_EXHAUSTED,
        PHONE_VERIFICATION_ATTEMPTS_EXHAUSTED
    }

    companion object {
        private const val ARG_VERIFICATION_TYPE = "ARG_VERIFICATION_TYPE"
        fun destination(type: Error): MatiDestination {
            return MatiDestination(R.id.to_attemptExhausted, Bundle().apply {
                putString(ARG_VERIFICATION_TYPE, type.name)
            })
        }
    }
}