package com.getmati.mati_sdk.ui.phonevalidation

import com.getmati.mati_sdk.models.clean.Country
import com.getmati.mati_sdk.models.clean.verification.VerificationType
import com.getmati.mati_sdk.server.RequestKit
import com.getmati.mati_sdk.server.api.PhoneInputApi
import com.getmati.mati_sdk.server.api.SkipApi
import com.getmati.mati_sdk.server.verification.StepVerificationResult
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.MutableStateFlow
import kotlinx.coroutines.flow.filterNotNull

internal class PhoneVerificationRepo(private val requestKit: RequestKit,
                                     private val phoneInputApi: PhoneInputApi,
                                     private val skipApi: SkipApi) {

    companion object {
        private const val TIMEOUT = 15000L
    }

    private val accessData get() = requestKit.accessData
    private val netManager get() = requestKit.netManager
    private val _countrySelectionFlow = MutableStateFlow<Country?>(null)
    val countrySelectionFlow: Flow<Country>
        get() = _countrySelectionFlow.filterNotNull()

    fun setCountryCode(givenCountry: Country) {
        _countrySelectionFlow.value = givenCountry
    }

    suspend fun verifyPhoneNumber(phoneDigits: String, country: Country, code: String): StepVerificationResult<Nothing> {
        return netManager.processVerification(
            TIMEOUT,
            VerificationType.PHONE_VERIFICATION,
            PhoneVerificationMapper()) {
            phoneInputApi.processVerification(
                accessData.verificationId,
                phoneDigits,
                country,
                code
            )
        }
    }

    suspend fun skip(): StepVerificationResult<Nothing> {
        return netManager.processVerification(
            TIMEOUT,
            VerificationType.PHONE_VERIFICATION,
            PhoneVerificationMapper(),
            null,
            true
        ) {
            skipApi.skip(accessData.verificationId, VerificationType.PHONE_VERIFICATION.id)
        }
    }

}