package com.getmati.mati_sdk.ui.searchable_dialog

import android.app.Dialog
import android.os.Bundle
import com.getmati.mati_sdk.models.clean.Country

internal class SearchableCountryDialog : SearchableListDialog<Country>() {

    companion object {
        private const val ARG_ITEMS = "ARG_ITEMS"

        fun newInstance(items: ArrayList<Country>) = SearchableCountryDialog().apply {
            arguments = Bundle().apply {
                putParcelableArrayList(ARG_ITEMS, items)
            }
        }
    }

    private lateinit var items:ArrayList<Country>

    override fun onCreateDialog(savedInstanceState: Bundle?): Dialog {
        items = requireArguments().getParcelableArrayList(ARG_ITEMS)!!
        return super.onCreateDialog(savedInstanceState)
    }

    override fun getTitles() = items.map { it.name }

    override fun getItem(position: Int) = items[position]

    interface SearchableItem {
        fun onSearchableItemClicked(item: Country)
    }

    override fun onItemClicked(title: String) {
        (parentFragment as? SearchableItem)?.onSearchableItemClicked(items.first { it.name == title })
    }
}