package com.getmati.mati_sdk.ui.searchable_dialog

import android.app.AlertDialog
import android.app.Dialog
import android.app.SearchManager
import android.content.Context
import android.content.DialogInterface
import android.os.Bundle
import android.text.TextUtils
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.view.WindowManager
import android.view.inputmethod.InputMethodManager
import android.widget.AdapterView.OnItemClickListener
import android.widget.ArrayAdapter
import android.widget.ListView
import android.widget.SearchView
import androidx.fragment.app.DialogFragment
import com.getmati.mati_sdk.R

internal abstract class SearchableListDialog<T> : DialogFragment(), SearchView.OnQueryTextListener, SearchView.OnCloseListener { // TODO Show using navigation
    private var _listViewItems: ListView? = null
    private var _onSearchTextChanged: OnSearchTextChanged? = null
    private var _searchView: SearchView? = null
    private var _strTitle: String? = null
    private var _strPositiveButtonText: String? = null
    private var _onClickListener: DialogInterface.OnClickListener? = null

    abstract fun onItemClicked(title: String)
    abstract fun getTitles():List<String>
    abstract fun getItem(position: Int): T

    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?,
                              savedInstanceState: Bundle?): View? {
        dialog!!.window!!.setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_STATE_VISIBLE)
        return super.onCreateView(inflater, container, savedInstanceState)
    }

    override fun onCreateDialog(savedInstanceState: Bundle?): Dialog {

        // Getting the layout inflater to inflate the view in an alert dialog.
        val inflater = LayoutInflater.from(activity)

        // Change End
        val rootView = inflater.inflate(R.layout.searchable_list_dialog, null)
        setData(rootView)
        val alertDialog = AlertDialog.Builder(activity)
        alertDialog.setView(rootView)
        if (_strPositiveButtonText != null) {
            alertDialog.setPositiveButton(_strPositiveButtonText, _onClickListener)
        }
        val strTitle = if (_strTitle == null) "Select Item" else _strTitle!!
        alertDialog.setTitle(strTitle)
        val dialog = alertDialog.create()
        dialog.window!!.setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_STATE_VISIBLE)
        return dialog
    }


    // Change End
    fun setTitle(strTitle: String?) {
        _strTitle = strTitle
    }

    fun setPositiveButton(strPositiveButtonText: String?) {
        _strPositiveButtonText = strPositiveButtonText
    }

    fun setPositiveButton(strPositiveButtonText: String?, onClickListener: DialogInterface.OnClickListener?) {
        _strPositiveButtonText = strPositiveButtonText
        _onClickListener = onClickListener
    }

    fun setOnSearchTextChangedListener(onSearchTextChanged: OnSearchTextChanged?) {
        _onSearchTextChanged = onSearchTextChanged
    }

    private fun setData(rootView: View) {
        val searchManager = requireActivity().getSystemService(Context.SEARCH_SERVICE) as SearchManager
        _searchView = rootView.findViewById<View>(R.id.search) as SearchView
        _searchView!!.setSearchableInfo(searchManager.getSearchableInfo(requireActivity().componentName))
        _searchView!!.isIconifiedByDefault = false
        _searchView!!.setOnQueryTextListener(this)
        _searchView!!.setOnCloseListener(this)
        _searchView!!.clearFocus()
        val mgr = requireActivity().getSystemService(Context.INPUT_METHOD_SERVICE) as InputMethodManager
        mgr.hideSoftInputFromWindow(_searchView!!.windowToken, 0)
        _listViewItems = rootView.findViewById(R.id.listItems)

        //create the adapter by passing your ArrayList data
        val listAdapter = ArrayAdapter(requireActivity(), android.R.layout.simple_list_item_1, getTitles())
        //attach the adapter to the list
        _listViewItems!!.adapter = listAdapter
        _listViewItems!!.isTextFilterEnabled = true
        _listViewItems!!.onItemClickListener = OnItemClickListener { parent, view, position, id ->
            onItemClicked(listAdapter.getItem(position)!!)
            dialog!!.dismiss()
        }
    }

    override fun onClose(): Boolean {
        return false
    }

    override fun onQueryTextSubmit(s: String): Boolean {
        _searchView!!.clearFocus()
        return true
    }

    override fun onQueryTextChange(s: String): Boolean {
//        listAdapter.filterData(s);
        if (TextUtils.isEmpty(s)) {
//                _listViewItems.clearTextFilter();
            (_listViewItems!!.adapter as ArrayAdapter<*>).filter.filter(null)
        } else {
            (_listViewItems!!.adapter as ArrayAdapter<*>).filter.filter(s)
        }
        if (null != _onSearchTextChanged) {
            _onSearchTextChanged!!.onSearchTextChanged(s)
        }
        return true
    }

    interface OnSearchTextChanged {
        fun onSearchTextChanged(strText: String?)
    }
}