package com.getmati.mati_sdk.ui.searchable_dialog

import android.app.Dialog
import android.os.Bundle

internal class SearchableStringDialog : SearchableListDialog<String>() {

    companion object {
        private const val ARG_ITEMS = "ARG_ITEMS"

        fun newInstance(items: ArrayList<String>) = SearchableStringDialog().apply {
            arguments = Bundle().apply {
                putStringArrayList(ARG_ITEMS, items)
            }
        }
    }

    private lateinit var items:ArrayList<String>

    override fun onCreateDialog(savedInstanceState: Bundle?): Dialog {
        items = requireArguments().getStringArrayList(ARG_ITEMS)!!
        return super.onCreateDialog(savedInstanceState)
    }

    override fun getTitles() = items

    override fun getItem(position: Int) = items[position]

    override fun onItemClicked(title: String) {
        (parentFragment as? SearchableItem)?.onSearchableItemClicked(title)
    }

    interface SearchableItem {
        fun onSearchableItemClicked(item: String)
    }
}