package com.getmati.mati_sdk.ui.selfie

import android.os.Bundle
import android.view.View
import com.getmati.mati_sdk.R
import com.getmati.mati_sdk.analytics.events.Clicked
import com.getmati.mati_sdk.analytics.events.UserAction
import com.getmati.mati_sdk.analytics.track
import com.getmati.mati_sdk.databinding.FragmentSelfieHintBinding
import com.getmati.mati_sdk.mati_navigation.MatiDestination
import com.getmati.mati_sdk.ui.common.KYCBaseFragment
import com.getmati.mati_sdk.ui.utils.view_binding.viewBinding

internal class SelfieHintFragment : KYCBaseFragment(R.layout.fragment_selfie_hint) {

    private val binding by viewBinding(FragmentSelfieHintBinding::bind)
    override val screenName = "selfieHint"

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        binding.actionPrimary.setOnClickListener {
            track(UserAction("capturePhotoButton", Clicked(), screenName))
            navigation.navigateTo(SelfieCameraFragment.destination())
        }
    }

    companion object {
        fun destination(): MatiDestination {
            return MatiDestination( R.id.to_selfieHint, Bundle())
        }
    }
}