package com.getmati.mati_sdk.ui.selfie

import android.net.Uri
import android.os.Bundle
import android.view.View
import com.getmati.mati_sdk.R
import com.getmati.mati_sdk.analytics.events.Clicked
import com.getmati.mati_sdk.analytics.events.UserAction
import com.getmati.mati_sdk.analytics.track
import com.getmati.mati_sdk.databinding.FragmentSelfiePreviewBinding
import com.getmati.mati_sdk.mati_navigation.MatiDestination
import com.getmati.mati_sdk.ui.common.KYCBaseFragment
import com.getmati.mati_sdk.ui.utils.view_binding.viewBinding
import com.getmati.mati_sdk.widgets.MatiToolbar
import java.io.File

internal class SelfiePreviewFragment : KYCBaseFragment(R.layout.fragment_selfie_preview) {

    override val screenName = "selfiePreview"
    private val binding by viewBinding(FragmentSelfiePreviewBinding::bind)
    private val path by lazy { requireArguments().getString(ARG_PATH)!! }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)

        binding.mainIvConfirmSelfieFrag.setImageURI(Uri.fromFile(File(path)))
        binding.uploadIv.setOnClickListener {
            track(UserAction("primaryButton", Clicked(), screenName))
            navigation.navigateTo(SelfieUploadFragment.destination(path))
        }
        binding.retryIv.setOnClickListener {
            track(UserAction("retakeButton", Clicked(), screenName))
            navigation.back()
        }
    }

    override fun configureToolbar(toolbar: MatiToolbar) {
        toolbar.changeTheme(MatiToolbar.Theme.NONE)
    }

    companion object {
        private const val ARG_PATH = "ARG_PATH"
        fun destination(pPath: String): MatiDestination {
            return MatiDestination(R.id.to_selfiePreview, Bundle().apply {
                putString(ARG_PATH, pPath)
            })
        }
    }
}