package com.getmati.mati_sdk.ui.selfie

import com.getmati.mati_sdk.managers.prefetch.PrefetchDataHolder
import com.getmati.mati_sdk.models.clean.verification.VerificationType
import com.getmati.mati_sdk.server.RequestKit
import com.getmati.mati_sdk.server.api.SelfieUploadApi
import com.getmati.mati_sdk.server.api.VoiceLivenessUploadApi
import com.getmati.mati_sdk.server.verification.StepVerificationResult

internal class SelfieRepo(
    private val requestKit: RequestKit,
    private val prefetchDataHolder: PrefetchDataHolder,
    private val selfieUploadApi: SelfieUploadApi
) {

    suspend fun upload(path: String): StepVerificationResult<Nothing> {
        return requestKit.netManager.processVerification(
            verificationType = VerificationType.SELFIE,
            mapper = SelfieUploadMapper(),
        ) {
            selfieUploadApi.uploadSelfie(prefetchDataHolder.prefetchedData.verificationId, path)
        }
    }
}

