package com.getmati.mati_sdk.ui.selfie

import androidx.lifecycle.ViewModel
import androidx.lifecycle.viewModelScope
import com.getmati.mati_sdk.analytics.events.BiometryUploadEvent
import com.getmati.mati_sdk.analytics.events.Uploaded
import com.getmati.mati_sdk.analytics.track
import com.getmati.mati_sdk.managers.prefetch.PrefetchDataHolder
import com.getmati.mati_sdk.models.clean.MediaVerificationError
import com.getmati.mati_sdk.server.verification.VerificationError
import com.getmati.mati_sdk.ui.BiometryType
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.flow.MutableStateFlow
import kotlinx.coroutines.flow.StateFlow
import kotlinx.coroutines.launch

internal class SelfieUploadVm(
    selfiePath : String,
    private val prefetchDataHolder : PrefetchDataHolder,
    private val selfieRepo: SelfieRepo
    ) : ViewModel() {

    private val _state = MutableStateFlow<State>(State.Loading)
    val state: StateFlow<State> get() = _state

    init {
        uploadSelfie(selfiePath)
    }


    private fun uploadSelfie(path : String) {
        _state.value = State.Loading
        viewModelScope.launch(Dispatchers.Main) {
            val prefetchedData = prefetchDataHolder.prefetchedData
            _state.value = selfieRepo.upload(path).run {
                if (error == null || error.type == MediaVerificationError.INPUT_LOCKED) {
                    track(BiometryUploadEvent(Uploaded(), BiometryType.SELFIE))
                    State.Success
                } else {
                    State.Error(error)
                }
            }
        }
    }

    sealed class State {
        object Loading : State()
        object Success : State()
        data class Error(val error: VerificationError) : State()
    }
}