package com.getmati.mati_sdk.ui.start

import android.os.Bundle
import android.view.View
import androidx.core.content.ContextCompat
import androidx.recyclerview.widget.RecyclerView
import com.getmati.mati_sdk.R
import com.getmati.mati_sdk.adapters.LanguageAdapter
import com.getmati.mati_sdk.databinding.FragmentSelectLanguageBinding
import com.getmati.mati_sdk.managers.prefetch.PrefetchDataHolder
import com.getmati.mati_sdk.mati_navigation.MatiDestination
import com.getmati.mati_sdk.ui.common.KYCBaseFragment
import com.getmati.mati_sdk.ui.utils.LocaleManager
import com.getmati.mati_sdk.ui.utils.view_binding.viewBinding
import org.koin.android.ext.android.inject

internal class LanguageSelectFragment : KYCBaseFragment(R.layout.fragment_select_language) {
    override val screenName = "languageSelect"
    private val binding by viewBinding(FragmentSelectLanguageBinding::bind)
    private val prefetchDataHolder by inject<PrefetchDataHolder>()

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        val recyclerView: RecyclerView = view.findViewById(R.id.recycler_view)
        val prefetchedData = prefetchDataHolder.prefetchedData
        val adapter = LanguageAdapter(
            LocaleManager.getLanguageId(),
            prefetchedData.config?.buttonColor ?: ContextCompat.getColor(
                view.context,
                R.color.matiColorAccent
            )
        )
        recyclerView.adapter = adapter
        binding.actionPrimary.setOnClickListener {
            val language = adapter.selectedLanguageId
            LocaleManager.setNewLocale(verificationActivity!!, language)
            navigation.back()
            verificationActivity!!.recreate()
        }
    }

    companion object {
        fun destination(): MatiDestination {
            return MatiDestination(R.id.to_languageSelect, Bundle())
        }
    }
}