package com.getmati.mati_sdk.ui.start

import androidx.annotation.DrawableRes
import androidx.annotation.StringRes
import com.getmati.mati_sdk.R
import com.getmati.mati_sdk.ui.*
import com.getmati.mati_sdk.ui.BiometryType
import com.getmati.mati_sdk.ui.BiometryUpload
import com.getmati.mati_sdk.ui.DocumentVerificationStep
import com.getmati.mati_sdk.ui.ESignVerificationStep
import com.getmati.mati_sdk.ui.EmailVerification
import com.getmati.mati_sdk.ui.SmsUpload
import com.getmati.mati_sdk.ui.VerificationStep
import com.getmati.mati_sdk.ui.web.BankAccountVerification
import com.getmati.mati_sdk.ui.web.PayrollAccountVerification
import com.getmati.mati_sdk.ui.web.WorkAccountVerification

internal data class VerificationStepDescription(
    val verificationStep: VerificationStep,
    @DrawableRes val image: Int,
    @StringRes val description: Int
) {
    companion object {
        fun fromVerificationStep(verificationStep: VerificationStep): VerificationStepDescription {
            return when (verificationStep) {
                is DocumentVerificationStep -> {
                    VerificationStepDescription(
                        verificationStep,
                        R.drawable.ic_document_icon,
                        R.string.label_upload_photos_proving_your_identity
                    )
                }
                is BiometryUpload -> {
                    return when (verificationStep.biometryType) {
                        BiometryType.SELFIE -> VerificationStepDescription(
                            verificationStep,
                            R.drawable.ic_biometric_icon,
                            R.string.label_take_a_selfie
                        )
                        BiometryType.SELFIE_VIDEO -> VerificationStepDescription(
                            verificationStep,
                            R.drawable.ic_biometric_icon,
                            R.string.label_record_a_short_selfie_video
                        )
                        else -> VerificationStepDescription(
                            verificationStep,
                            R.drawable.ic_voicebio_icon,
                            R.string.label_voiceliveness_title
                        )
                    }
                }
                is ESignVerificationStep -> {
                    VerificationStepDescription(
                        verificationStep,
                        R.drawable.ic_esign,
                        R.string.label_signature_centerTitle
                    )
                }
                is SmsUpload -> {
                    VerificationStepDescription(
                        verificationStep, R.drawable.ic_phone, R.string.label_sms_check_action
                    )
                }
                is EmailVerification -> {
                    VerificationStepDescription(
                        verificationStep,
                        R.drawable.ic_email_verification_step,
                        R.string.label_email_validation_action
                    )
                }
                is WebVerificationStep -> {
                    when (verificationStep.type) {
                        BankAccountVerification -> VerificationStepDescription(
                            verificationStep,
                            R.drawable.ic_bank_verification_step,
                            R.string.bank_account_title
                        )
                        PayrollAccountVerification -> VerificationStepDescription(
                            verificationStep,
                            R.drawable.ic_payroll_account_step,
                            R.string.payroll_account_title
                        )
                        WorkAccountVerification -> VerificationStepDescription(
                            verificationStep,
                            R.drawable.ic_work_verification_step,
                            R.string.work_account_title
                        )
                        else -> throw Exception("Unable to parse web verification step")
                    }
                }
                else -> throw Exception("Unable to parse verification step")
            }
        }
    }
}