package com.getmati.mati_sdk.ui.start

import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.ImageView
import android.widget.TextView
import androidx.recyclerview.widget.RecyclerView
import com.getmati.mati_sdk.R
import com.getmati.mati_sdk.models.clean.verification.VerificationFlow

internal class VerificationStepDescriptionAdapter(verificationFlow: VerificationFlow) :
    RecyclerView.Adapter<VerificationStepDescriptionViewHolder>() {
    private val verificationStepsDescription by lazy {
        val result = mutableListOf<VerificationStepDescription>()
        verificationFlow.verificationSteps.forEach { verificationStep ->
            if (!result.any { description -> description.verificationStep::class == verificationStep::class }) {
                result.add(VerificationStepDescription.fromVerificationStep(verificationStep))
            }
        }
        result
    }

    override fun onCreateViewHolder(
        viewGroup: ViewGroup,
        viewType: Int
    ): VerificationStepDescriptionViewHolder {
        return VerificationStepDescriptionViewHolder(
            LayoutInflater.from(viewGroup.context).inflate(
                when (itemCount) {
                    1 -> R.layout.item_verification_preview_big
                    2 -> R.layout.item_verification_preview_small_horizontal
                    else -> R.layout.item_verification_preview_small
                }, viewGroup, false
            )
        )
    }

    override fun onBindViewHolder(holder: VerificationStepDescriptionViewHolder, position: Int) {
        holder.bind(verificationStepsDescription[position])
    }

    override fun getItemCount(): Int {
        return verificationStepsDescription.size
    }
}

internal class VerificationStepDescriptionViewHolder(itemView: View) :
    RecyclerView.ViewHolder(itemView) {
    fun bind(verificationStepDescription: VerificationStepDescription) {
        itemView.findViewById<ImageView>(R.id.verificationStepImg)
            .setImageResource(verificationStepDescription.image)
        itemView.findViewById<TextView>(R.id.verificationStepTxt)
            .setText(verificationStepDescription.description)
    }
}